#ifndef __C4DBASESOUND_H
#define __C4DBASESOUND_H

#include "ge_math.h"
#include "c4d_basetime.h"
#include "c4d_baselist.h"

class BaseKey;
class Filename;
class BaseBitmap;

struct SData
{
	WORD l;	// left channel
	WORD r; // right channel
};

class BaseSound : public Atom
{
	private:
		BaseSound(void);
	public:
		BaseSound *GetClone(void);
		Bool CopyTo(BaseSound *dest);
	
		Bool Init(LONG samples, LONG fmode, Bool stereo, Bool b16);
		void FlushAll(void);
		Bool Load(const Filename &fn);
		Bool Save(const Filename &fn);

		void GetSoundInfo(Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length);
		
		void GetSample(LONG i, SData *data);
		void SetSample(LONG i, const SData &data);

		BaseBitmap *GetBitmap(LONG width, LONG height, const BaseTime &start, const BaseTime &stop);

		BaseKey *GetFirstMarker(void);
		Bool InsertMarker(BaseKey *mk, BaseKey *pred=NULL);
		
		CHAR *GetRAW(void);

		static BaseSound *Alloc(void);
		static void Free(BaseSound *&v);
};

#endif
